using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Input.Touch;
using Microsoft.Xna.Framework.Media;

using Microsoft.Devices.Sensors;

namespace CheeseLander
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class CheeseLanderGame : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        int displayWidth;
        int displayHeight;

        // Ser 
        Texture2D cheeseTexture;
        Rectangle cheeseRectangle;
        int cheeseWidth;
        float cheeseWidthFactor = 8;

        float cheeseX;
        float cheeseY;

        float cheeseXSpeed;
        float cheeseYSpeed;

        float cheeseXAcceleration;
        float cheeseYAcceleration;

        float cheeseMaxXLandSpeed = 0.4f;
        float cheeseMaxYLandSpeed = 0.4f;

        // Chleb
        Texture2D breadTexture;
        Rectangle breadRectangle;
        int breadWidth;
        float breadWidthFactor = 3;

        // Ta i komunikaty
        Texture2D wonTexture;
        Texture2D lostTexture;
        Texture2D backgroundTexture;
        Rectangle fullScreenDrawPos;

        // Wartoci przyspieszenia

        Accelerometer accel;
        Vector3 accelReading;
        float acceleratorPower = 0.1f;

        enum gameState
        {
            playing,
            won,
            lost
        }

        private gameState state = gameState.playing;

        SoundEffect wonSound;
        SoundEffect lostSound;

        Random rand = new Random();

        public CheeseLanderGame()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = 240;
            graphics.PreferredBackBufferHeight = 400;

            // Domylna czstotliwo odwieania dla Windows Phone wynosi 30 fps.
            TargetElapsedTime = TimeSpan.FromTicks(333333);
        }


        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            accel = new Accelerometer();

            accel.ReadingChanged += new EventHandler<AccelerometerReadingEventArgs>(accel_ReadingChanged);

            accel.Start();

            base.Initialize();
        }

        void accel_ReadingChanged(object sender, AccelerometerReadingEventArgs e)
        {
            accelReading.X = (float)e.X;
            accelReading.Y = (float)e.Y;
            accelReading.Z = (float)e.Z;
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            displayWidth = GraphicsDevice.Viewport.Width;
            displayHeight = GraphicsDevice.Viewport.Height;

            cheeseWidth = (int)(displayWidth / cheeseWidthFactor);
            breadWidth = (int)(displayWidth / breadWidthFactor);

            // Stwrz prostokt do rysowania 
            // Rozmiar sera powinien wynosi 1/12 szerokosci ekranu
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // Wczytaj obraz sera i ustaw rozmiar prostokta wywietlania
            cheeseTexture = Content.Load<Texture2D>("cheese");
            cheeseRectangle.Width = cheeseWidth;
            float aspectRatio = (float)cheeseTexture.Width / cheeseTexture.Height;
            cheeseRectangle.Height = (int)((cheeseWidth / aspectRatio) + 0.5f);

            // Wczytaj obraz chleba i ustaw rozmiar prostokta wywietlania
            breadTexture = Content.Load<Texture2D>("bread");
            breadRectangle.Width = breadWidth;
            aspectRatio = (float)breadTexture.Width / breadTexture.Height;
            breadRectangle.Height = (int)((breadWidth / aspectRatio) + 0.5f);

            // Wczytaj obraz ta
            backgroundTexture = Content.Load<Texture2D>("background");

            // Wczytaj tekstury dla zwycistwa i przegranej
            wonTexture = Content.Load<Texture2D>("wonScreen");
            lostTexture = Content.Load<Texture2D>("lostScreen");

            fullScreenDrawPos = new Rectangle(
                0, 0,
                displayWidth, displayHeight);

            // Wczytaj efekty dwikowe
            wonSound = Content.Load<SoundEffect>("wonSound");
            lostSound = Content.Load<SoundEffect>("lostSound");

            newGame();

        }

        /// <summary>
        /// UnloadContent bdzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        private void updateGame()
        {
            // Aktualizuj skadowe X i Y pooenia

            cheeseXAcceleration = accelReading.X * acceleratorPower;
            cheeseYAcceleration = -accelReading.Y * acceleratorPower;

            cheeseXSpeed = cheeseXSpeed + cheeseXAcceleration;
            cheeseYSpeed = cheeseYSpeed + cheeseYAcceleration;

            cheeseX = cheeseX + cheeseXSpeed;
            cheeseY = cheeseY + cheeseYSpeed;

            // Ustaw jako wsprzdne prostokta dla wywietlania sera wartoci cheeseX oraz cheeseY
            cheeseRectangle.X = (int)(cheeseX + 0.5f);
            cheeseRectangle.Y = (int)(cheeseY + 0.5f);

            // Ograniczenia na bokach

            if (cheeseX < 0)
            {
                cheeseXSpeed = (float)Math.Abs(cheeseXSpeed);
            }

            if (cheeseY < 0)
            {
                cheeseYSpeed = (float)Math.Abs(cheeseYSpeed);
            }

            if (cheeseRectangle.Right > displayWidth)
            {
                cheeseXSpeed = -1 * (float)Math.Abs(cheeseXSpeed);
            }

            if (cheeseRectangle.Bottom > GraphicsDevice.Viewport.Height)
            {
                cheeseYSpeed = -1 * (float)Math.Abs(cheeseYSpeed);
            }

            if (cheeseRectangle.Intersects(breadRectangle))
            {
                // Moliwa wygrana 
                if (cheeseRectangle.Top < breadRectangle.Top &&
                    cheeseRectangle.Left >= breadRectangle.Left &&
                    cheeseRectangle.Right <= breadRectangle.Right &&
                    Math.Abs(cheeseXSpeed) < cheeseMaxXLandSpeed &&
                    Math.Abs(cheeseYSpeed) < cheeseMaxYLandSpeed)
                {
                    // prawidowe ldowanie - gracz wygra
                    gameWon();
                }
                else
                {
                    // nieprawidowe ldowanie - gracz przegra
                    gameLost();
                }
            }
        }

        private void gameWon()
        {
            wonSound.Play();
            state = gameState.won;
        }

        private void gameLost()
        {
            lostSound.Play();
            state = gameState.lost;
        }

        private void newGame()
        {
            // Umie ser w losowym miejscu na grze ekranu
            cheeseX = rand.Next(displayWidth - cheeseWidth);
            cheeseY = 0;

            cheeseXSpeed = 0;
            cheeseYSpeed = 0;

            // Przemie chleb poziomo w nowe miejsce
            breadRectangle.X = rand.Next(displayWidth - breadWidth);
            breadRectangle.Y = displayHeight - breadRectangle.Height;

            // Rozpocznij rozgrywk
            state = gameState.playing;
        }

        private void checkNewGame()
        {
            // Odczytaj ekran dotykowy

            TouchCollection touches = TouchPanel.GetState();

            foreach (TouchLocation location in touches)
            {
                if (location.State == TouchLocationState.Pressed)
                {
                    newGame();
                    break;
                }
            }
        }


        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala opusci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            switch (state)
            {
                case gameState.playing:
                    updateGame();
                    break;
                case gameState.lost:
                    checkNewGame();
                    break;
                case gameState.won:
                    checkNewGame();
                    break;
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            switch (state)
            {
                case gameState.playing:
                    spriteBatch.Draw(backgroundTexture, fullScreenDrawPos, Color.White);
                    spriteBatch.Draw(breadTexture, breadRectangle, Color.White);
                    spriteBatch.Draw(cheeseTexture, cheeseRectangle, Color.White);
                    break;

                case gameState.won:
                    spriteBatch.Draw(wonTexture, fullScreenDrawPos, Color.White);
                    break;

                case gameState.lost:
                    spriteBatch.Draw(lostTexture, fullScreenDrawPos, Color.White);
                    break;
            }

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
